<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';


if (!isset($_POST['service_id'])) {
    echo json_encode(["error" => "No service_id provided"]);
    exit;
}

$service_id = intval($_POST['service_id']);

$sql = "SELECT name as service_name FROM tbl_service_type WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $service_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(["service_name" => $row['service_name']]);
} else {
    echo json_encode(["service_name" => "Unknown Service"]);
}

$stmt->close();
$conn->close();
?>

