<?php
header('Content-Type: application/json');
include '../connection.php';

// Get last check time from query string
$last_check = isset($_GET['last_check']) ? $_GET['last_check'] : '1970-01-01 00:00:00';

// Count orders created after last check
$stmt = $conn->prepare("SELECT COUNT(*) AS new_orders FROM tbl_order WHERE status = 'Completed' and assign_del_status is null and created_at > ?");
$stmt->bind_param("s", $last_check);
$stmt->execute();
$result = $stmt->get_result()->fetch_assoc();

echo json_encode([
    "success" => true,
    "new_orders" => $result['new_orders'],
    "current_time" => date("Y-m-d H:i:s")
]);

$conn->close();
?>
