<?php
require 'firebase_service.php'; // include the JSON variable

$keyFile = json_decode($firebaseServiceAccount, true);

// --- Helper functions to create JWT without Composer ---
function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function createJWT($keyFile) {
    $header = ['alg' => 'RS256', 'typ' => 'JWT'];
    $now = time();
    $payload = [
        'iss'   => $keyFile['client_email'],
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
        'aud'   => 'https://oauth2.googleapis.com/token',
        'iat'   => $now,
        'exp'   => $now + 3600
    ];

    $header_encoded = base64url_encode(json_encode($header));
    $payload_encoded = base64url_encode(json_encode($payload));

    $unsigned_token = $header_encoded . '.' . $payload_encoded;

    // Sign with private key
    $private_key = $keyFile['private_key'];
    openssl_sign($unsigned_token, $signature, $private_key, OPENSSL_ALGO_SHA256);

    $signature_encoded = base64url_encode($signature);

    return $unsigned_token . '.' . $signature_encoded;
}

// --- Generate access token ---
$jwt = createJWT($keyFile);

$postData = http_build_query([
    'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
    'assertion'  => $jwt
]);

$ch = curl_init('https://oauth2.googleapis.com/token');
curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ['Content-Type: application/x-www-form-urlencoded'],
    CURLOPT_POSTFIELDS => $postData
]);

$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

$access_token = $data['access_token'] ?? null;

if ($access_token) {
    echo "Access Token: " . $access_token;
} else {
    echo "Failed to get access token\n";
    print_r($data);
}
