<?php
/*
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
include '../connection.php';

$service_id = $_POST["service_id"];

$sql = "SELECT p.id as product_id, p.name as product_name, sp.price
        FROM tbl_product_type p
        JOIN tbl_service_product_prices sp 
          ON p.id = sp.product_id
        WHERE sp.service_id = ?";
        
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $service_id);
$stmt->execute();
$result = $stmt->get_result();

$products = [];
while ($row = $result->fetch_assoc()) {
    $products[] = $row;
}

echo json_encode([
    "success" => true,
    "products" => $products
]);
*/

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include '../connection.php';

if (!$conn) {
    echo json_encode([
        "success" => false,
        "error" => "Database connection failed"
    ]);
    exit;
}

if (!isset($_POST["service_id"]) || !is_numeric($_POST["service_id"])) {
    echo json_encode([
        "success" => false,
        "error" => "Invalid service ID"
    ]);
    exit;
}

$service_id = (int) $_POST["service_id"];

$sql = "SELECT 
            p.id AS product_id,
            p.name AS product_name,
            IFNULL(sp.price, 0) AS price
        FROM tbl_product_type p
        INNER JOIN tbl_service_product_prices sp 
            ON p.id = sp.product_id
        WHERE sp.service_id = ?";

$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        "success" => false,
        "error" => "Prepare failed",
        "mysql_error" => $conn->error
    ]);
    exit;
}

$stmt->bind_param("i", $service_id);

if (!$stmt->execute()) {
    echo json_encode([
        "success" => false,
        "error" => "Execute failed",
        "mysql_error" => $stmt->error
    ]);
    exit;
}

/**
 * ✅ IMPORTANT FIX
 * Using bind_result instead of get_result
 */
$stmt->bind_result($product_id, $product_name, $price);

$products = [];
while ($stmt->fetch()) {
    $products[] = [
        "product_id" => $product_id,
        "product_name" => $product_name,
        "price" => (float)$price
    ];
}

echo json_encode([
    "success" => true,
    "products" => $products
]);

