<?php
/*
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
    exit;
}

// Get POST body
$input = json_decode(file_get_contents("php://input"), true);

if (!isset($input['user_id'])) {
    echo json_encode([
        "success" => false,
        "message" => "Missing user_id"
    ]);
    exit;
}

$user_id = intval($input['user_id']);

$sql = "SELECT available_balance FROM tbl_referral_rewards WHERE user_id = ? LIMIT 1";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode([
        "success" => true,
        "available_balance" => (float)$row["available_balance"]
    ]);
} else {
    echo json_encode([
        "success" => true,
        "available_balance" => 0.00
    ]);
}

$stmt->close();
$conn->close();
*/

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

/* ---------------------------
   Allow only POST
--------------------------- */
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "success" => false,
        "message" => "Invalid request method"
    ]);
    exit;
}

/* ---------------------------
   Read JSON input
--------------------------- */
$input = json_decode(file_get_contents("php://input"), true);

if (!isset($input['user_id']) || !is_numeric($input['user_id'])) {
    echo json_encode([
        "success" => false,
        "message" => "Missing or invalid user_id"
    ]);
    exit;
}

$user_id = (int) $input['user_id'];

/* ---------------------------
   Prepare query
--------------------------- */
$sql = "SELECT available_balance FROM tbl_referral_rewards WHERE user_id = ? LIMIT 1";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        "success" => false,
        "message" => "Query prepare failed"
    ]);
    exit;
}

$stmt->bind_param("i", $user_id);
$stmt->execute();

/* ---------------------------
   Bind result (NO get_result)
--------------------------- */
$stmt->bind_result($available_balance);

/* ---------------------------
   Fetch result
--------------------------- */
if ($stmt->fetch()) {
    echo json_encode([
        "success" => true,
        "available_balance" => (float)$available_balance
    ]);
} else {
    echo json_encode([
        "success" => true,
        "available_balance" => 0.00
    ]);
}

/* ---------------------------
   Close connections
--------------------------- */
$stmt->close();
$conn->close();

