<?php
/*
header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');
include '../connection.php';

$user_id = $_GET['user_id'];

if (!$user_id) {
    echo json_encode(["success" => false, "message" => "Missing user_id"]);
    exit;
}

$stmt = $conn->prepare("SELECT address, latitude, longitude FROM tbl_pickup_location WHERE user_id = ? ORDER BY id ASC LIMIT 1");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(["success" => true, "data" => $row]);
} else {
    echo json_encode(["success" => false, "message" => "No location found"]);
}
*/

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

/* ---------------------------
   Validate user_id
--------------------------- */
if (!isset($_GET['user_id']) || !is_numeric($_GET['user_id'])) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid or missing user_id"
    ]);
    exit;
}

$user_id = (int) $_GET['user_id'];

/* ---------------------------
   Prepare query
--------------------------- */
$sql = "
    SELECT address, latitude, longitude
    FROM tbl_pickup_location
    WHERE user_id = ?
    ORDER BY id ASC
    LIMIT 1
";

$stmt = $conn->prepare($sql);

if (!$stmt) {
    echo json_encode([
        "success" => false,
        "message" => "Query prepare failed"
    ]);
    exit;
}

$stmt->bind_param("i", $user_id);
$stmt->execute();

/* ---------------------------
   Bind result (NO get_result)
--------------------------- */
$stmt->bind_result($address, $latitude, $longitude);

/* ---------------------------
   Fetch data
--------------------------- */
if ($stmt->fetch()) {
    echo json_encode([
        "success" => true,
        "data" => [
            "address" => $address,
            "latitude" => (float)$latitude,
            "longitude" => (float)$longitude
        ]
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "No location found"
    ]);
}

$stmt->close();
$conn->close();

