<?php
/*
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

$user_id = $_POST['user_id'];
//$user_id = 2;

$sql = "SELECT COUNT(DISTINCT service_id) as count FROM tblcart WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$response = array("count" => 0);

if ($row = $result->fetch_assoc()) {
    $response['count'] = $row['count'];
}

echo json_encode($response);
*/

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include '../connection.php';

$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;

$response = array("count" => 0);

if ($user_id > 0) {
    $sql = "SELECT COUNT(DISTINCT service_id) as count FROM tblcart WHERE user_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();

    // Use bind_result instead of get_result
    $stmt->bind_result($count);
    if ($stmt->fetch()) {
        $response['count'] = $count;
    }

    $stmt->close();
}

echo json_encode($response);
$conn->close();


