<?php
header('Content-Type: application/json');
include '../connection.php';

// Expected POST params: assignment_id, status_id
$assignment_id = isset($_POST['assignment_id']) ? intval($_POST['assignment_id']) : 0;
$status_id = isset($_POST['status_id']) ? intval($_POST['status_id']) : 0;

if ($assignment_id && $status_id >= 1 && $status_id <= 5) {
    $stmt = $conn->prepare("UPDATE tbl_delevery_assign SET status_id = ? WHERE id = ?");
    $stmt->bind_param("ii", $status_id, $assignment_id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Delivery status updated']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update status']);
    }
    $stmt->close();
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid parameters']);
}

$conn->close();
?>
