<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

include_once "../connection.php";

try {
    if (!isset($_POST['order_id'])) {
        throw new Exception("order_id is required");
    }

    $order_id = intval($_POST['order_id']);

    $order_sql = "SELECT * FROM tbl_order WHERE id='$order_id'";
    $order_res = mysqli_query($conn, $order_sql);
    if (!$order_res) throw new Exception(mysqli_error($conn));
    if (mysqli_num_rows($order_res) == 0) throw new Exception("Order not found");
    $order = mysqli_fetch_assoc($order_res);

    $user_id = $order['user_id'];
    $user_sql = "SELECT fname,lname FROM tblcred WHERE userid='$user_id'";
    $user_res = mysqli_query($conn, $user_sql);
    if (!$user_res) throw new Exception(mysqli_error($conn));
    $user = mysqli_fetch_assoc($user_res);

    $profile_sql = "SELECT phone FROM tbl_profile WHERE user_id='$user_id'";
    $profile_res = mysqli_query($conn, $profile_sql);
    if (!$profile_res) throw new Exception(mysqli_error($conn));
    $profile = mysqli_fetch_assoc($profile_res);

    $items_sql = "
        SELECT i.id, i.quantity, i.unit_price, i.total_price,
               p.name AS product_name, s.name AS service_name
        FROM tbl_order_items i
        LEFT JOIN tbl_product_type p ON i.product_id = p.id
        LEFT JOIN tbl_service_type s ON i.service_id = s.id
        WHERE i.order_id='$order_id'
    ";
    $items_res = mysqli_query($conn, $items_sql);
    if (!$items_res) throw new Exception(mysqli_error($conn));
    $order_items = [];
    while ($row = mysqli_fetch_assoc($items_res)) {
        $order_items[] = $row;
    }

    echo json_encode([
        "success" => true,
        "order" => $order,
        "customer" => [
            "name" => $user ? ucwords($user['fname']) . " " . ucwords($user['lname']) : "",
            "phone" => $profile ? $profile['phone'] : "",
        ],
        "items" => $order_items
    ]);

} catch (Exception $e) {
    echo json_encode([
        "success" => false,
        "message" => $e->getMessage()
    ]);
}

