<?php
header("Content-Type: application/json");
include "../connection.php";

$response = array();

// -----------------------------------------------------------
// Validate required fields
// -----------------------------------------------------------
if (
    !isset($_POST["outlet_id"]) ||
    !isset($_POST["outlet_name"]) ||
    !isset($_POST["address"]) ||
    !isset($_POST["latitude"]) ||
    !isset($_POST["longitude"]) ||
    !isset($_POST["status"])
) {
    $response["success"] = false;
    $response["message"] = "Required fields missing";
    echo json_encode($response);
    exit;
}

$outlet_id      = $_POST["outlet_id"];
$outlet_name    = $_POST["outlet_name"];
$address        = $_POST["address"];
$latitude       = $_POST["latitude"];
$longitude      = $_POST["longitude"];
$status         = $_POST["status"];
$employee_id    = isset($_POST["employee_id"]) ? $_POST["employee_id"] : NULL;

// -----------------------------------------------------------
// Query to update outlet
// -----------------------------------------------------------
$query = "
    UPDATE tbl_outlet SET 
        outlet_name = ?,
        address = ?,
        latitude = ?,
        longitude = ?,
        assigned_employee_id = ?,
        status = ?
    WHERE outlet_id = ?
";

$stmt = $conn->prepare($query);

$stmt->bind_param(
    "sssdsii",
    $outlet_name,
    $address,
    $latitude,
    $longitude,
    $employee_id,
    $status,
    $outlet_id
);

// -----------------------------------------------------------
// Execute update
// -----------------------------------------------------------
if ($stmt->execute()) {
    $response["success"] = true;
    $response["message"] = "Outlet updated successfully";
} else {
    $response["success"] = false;
    $response["message"] = "Failed to update outlet";
}

$stmt->close();
$conn->close();

echo json_encode($response);
?>
