<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
include '../connection.php';

$id = isset($_POST['id']) ? intval($_POST['id']) : 0;

if ($id <= 0) {
    echo json_encode(["success" => false, "message" => "Missing or invalid ID"]);
    exit;
}

$stmt = $conn->prepare("DELETE FROM tbl_service_product_prices WHERE id=?");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Price deleted successfully"]);
} else {
    echo json_encode(["success" => false, "message" => "Failed to delete price"]);
}

$stmt->close();
$conn->close();
?>