<?php
// deleteOutlet.php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header("Content-Type: application/json");

// Include database connection
include "../connection.php";

// Check if outlet_id is sent via POST
if(isset($_POST['outlet_id']) && !empty($_POST['outlet_id'])) {
    $outlet_id = $_POST['outlet_id'];

    // Prepare the SQL statement
    $stmt = $conn->prepare("DELETE FROM tbl_outlet WHERE outlet_id = ?");
    $stmt->bind_param("i", $outlet_id);

    if($stmt->execute()) {
        if($stmt->affected_rows > 0) {
            echo json_encode([
                "success" => true,
                "message" => "Outlet deleted successfully."
            ]);
        } else {
            echo json_encode([
                "success" => false,
                "message" => "No outlet found with this ID."
            ]);
        }
    } else {
        echo json_encode([
            "success" => false,
            "message" => "Error deleting outlet: " . $stmt->error
        ]);
    }

    $stmt->close();
} else {
    echo json_encode([
        "success" => false,
        "message" => "Outlet ID is required."
    ]);
}

$conn->close();
?>
